import java.util.*;
/**
 * Classe che rappresenta la bacheca elettronica da cui vengono prelevati ed
 * inseriti i messaggi del newsgroup
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 *
 */
public class Showcase {
	protected MsgTree tree;
	
	/**
	 * Costruttore di Showcase con un parametro: l'albero contenente 
	 * la gerarchia dei messaggi del newsgroup
	 * @param t albero dei messaggi
	 */
	public Showcase(MsgTree t){
		tree=t;
	}
	
	/**
	 * Metodo che permette di inserire un nuovo messaggio in bacheca e 
	 * che dovr aggiornare l'albero dei messaggi 
	 * @param msg messaggio da inserire
	 * @param father messaggio di cui msg  risposta,  a null 
	 * 			se il messaggio non  una risposta
	 * @return se l'inserimento  andato a buon fine
	 */
	public boolean insertMsg(Msg msg,Msg father){
		try {
			if(tree!=null){
				tree.insert(msg,father);
				return true;
			}
			return false;
		}
		catch(NoSuchNodeException e){
			return false;
		}
	}
	
	/**
	 * Metodo che permette di fare un ricerca per oggetto tra i messaggi.
	 * Il metodo ritorna tutti i messaggi con il dato oggetto
	 * @param obj Stringa che rappresenta l'oggetto del messaggio
	 * @return i messaggi con il dato oggetto
	 */
	public Msg[] readMsgs(String obj){
		if (this.tree==null)return null;
		return this.msgByObj(obj,this.tree.getRoot());
	}
	
	/**
	 * Metodo che permette di fare un ricerca per oggetto e mittente tra i messaggi.
	 * Il metodo ritorna tutti i messaggi con il dato mittente ed oggetto
	 * @param sender mittente del messaggio
	 * @param obj Stringa che rappresenta l'oggetto del messaggio
	 * @return i messaggi con il dato oggetto
	 */
	public Msg[] readMsgs(Person sender,String obj){
		if (this.tree==null)return null;
		Msg[] objMsg=this.msgByObj(obj,this.tree.getRoot());
		if(objMsg==null) return null;
		Msg[] respMsg=null;
		Vector goodMsg=new Vector();
		for(int i=0;i<objMsg.length;i++){
			//curMitt contiene il mittente del messaggio corrente con quell'oggetto
			Person curMitt=objMsg[i].getSender();
			
			//controllo ora che il mittente sia lo stesso e per fare ci,
			//controllo che tutti i campi siano uguali
			if(curMitt.getNickname().equalsIgnoreCase(sender.getNickname())){
				if((sender.getEmail()!=null)&&(curMitt.getEmail()!=null))
					if(!(sender.getEmail().equals(curMitt.getEmail())))
						continue;
				if((sender.getName()!=null)&&(curMitt.getName()!=null))
					if(!(curMitt.getName().equals(sender.getName())))
						continue;
				if((sender.getSurname()!=null)&&(curMitt.getSurname()!=null))
					if(!(curMitt.getSurname().equals(sender.getSurname())))
						continue;
				goodMsg.add(objMsg[i]);
			}
		}//end for
		if(goodMsg.size()!=0){
			respMsg=new Msg[goodMsg.size()];
			for(int i=0;i<goodMsg.size();i++)
				respMsg[i]=(Msg)goodMsg.get(i);
		}
		return respMsg;
		
	}
	
	/**
	 * Metodo che permette di trovare tutti i messaggi con un dato mittente,
	 * oggetto e data.
	 * @param sender mittente del messaggio
	 * @param obj Stringa che rappresenta l'oggetto del messaggio
	 * @param timestamp data del messaggio
	 * @return i messaggi con il dato oggetto
	 */
	public Msg[] readMsgs(Person sender,String obj, Date timestamp){
		Msg[] partialMsg=this.readMsgs(sender,obj);
		Msg[] respMsg=null;
		Vector goodMsg=new Vector();
		if (partialMsg==null)return null;
		for(int i=0;i<partialMsg.length;i++){
			//data del messaggio corrente
			Date curTime=partialMsg[i].getTimestamp();
			//controllo che questo sia lo stesso dell'orario richiesto
			if(timestamp.equals(curTime))
				goodMsg.add(partialMsg[i]);
		}
		if(goodMsg.size()!=0){
			respMsg=new Msg[goodMsg.size()];
			for(int i=0;i<goodMsg.size();i++)
				respMsg[i]=(Msg)goodMsg.get(i);
		}
		return respMsg;
	}
	
	/**
	 * Metodo che permette di trovare il messaggio con il dato ID univoco,
	 * proprio del messaggio.
	 * @param ID ID uniovoco del messaggio
	 * @return i messaggi con il dato oggetto
	 */
	public Msg readMsg(String ID){
		if (this.tree==null)return null;
		if(!this.tree.table.containsKey(ID)) 
			return null;
		TreeNode curNode=(TreeNode)this.tree.getTable().get(ID);
		Msg IDMsg=null;
		if(curNode!=null)
			IDMsg=curNode.getMsg();
		return IDMsg;
	}
	
	
	/**
	 * Metodo che permette di ritornare un aray di messaggi che sono quelli 
	 * risposta a un messaggio identificato dal suo identificativo univoco
	 * @param ID Stringa rappresentante l'ID univoco del messaggio 
	 * di cui si cercano le risposte
	 * @return array dei messaggi risposta del messaggio in ingresso
	 */
	public Msg[]readResponse(String ID){
		Msg []response=null;
		if (this.tree==null)return null;
		if(!this.tree.table.containsKey(ID))
			return null;
		TreeNode curNode=(TreeNode)this.tree.getTable().get(ID);
		if(curNode!=null){
			int numMess=curNode.getSons().size();
			if(numMess==0)
				return null;
			response=new Msg[numMess];
			for(int i=0;i<numMess;i++){
				TreeNode curSon=(TreeNode)curNode.getSons().get(i);
				response[i]=(Msg)curSon.getMsg();
			}
		}
		return response;
	}
	
	/**
	 * Metodo che ritorna tutti i messaggi di primo 
	 * livello, cio quelli che non sono risposta di nessuno
	 * @return array di stringhe, contenente gli oggetti dei messaggi
	 */
	public Msg[] readAll(){
		if(this.tree !=null){
			int numMess=this.tree.getRoot().getSons().size();
			Msg []messRead=new Msg[numMess];
			Vector nodes=this.tree.getRoot().getSons();
			for(int i=0;i<numMess;i++){
				TreeNode curNode=(TreeNode)nodes.elementAt(i);
				messRead[i]=curNode.getMsg();
			}
			return messRead;
		}
		return null;
	}
	
	//-----------------------------------------------------------------------------
	//Metodi propri della classe
	//-----------------------------------------------------------------------------
	
	/**
	 * Metodo che naviga nell'albero dei messaggi e ricava tutti quelli con il
	 * dato oggetto del messaggio
	 * @param obj oggetto del messaggio
	 * @param curNode nodo corrente in cui si guarda se l'oggetto 
	 * corrisponde a quello richiesto e chiamare ricorsivamente il metodo sui
	 * propri nodi figli
	 */
	protected Msg[] msgByObj(String obj,TreeNode curNode){
		Vector goodMsg=new Vector();
		Msg [] returnMsg=null;
		if (curNode==null)return null;
		if (obj==null)return null;
		if(curNode.getMsg()!=null){
			if(curNode.getMsg().getObject().equalsIgnoreCase(obj))
				goodMsg.add(curNode.getMsg());
		}
		Vector sons=curNode.getSons();
		if(sons.size()==0){
			if (goodMsg.size()==1){
				returnMsg=new Msg[1];
				returnMsg[0]=(Msg)goodMsg.get(0);
			}
		}
		else{
			for(int i=0;i<sons.size();i++){
				Msg[] msgApp=msgByObj(obj,(TreeNode)curNode.getSons().get(i));
				if (msgApp!=null)
					for(int j=0;j<msgApp.length;j++)
						goodMsg.add(msgApp[j]);
			}
			if(goodMsg.size()==0)
				return returnMsg;
			returnMsg=new Msg[goodMsg.size()];
			for(int i=0;i<returnMsg.length;i++)
				returnMsg[i]=(Msg)goodMsg.get(i);	
		}
		return returnMsg;
	}
	

}
